#! /bin/bash
runUser=`whoami`

function getUser {
    user=
    userPath=/run/systemd/users
    if [ ! -d $userPath ]; then
		user=$(w -h | awk 'NR==1' | awk '{print $1}')
		#echo $user
		return
	fi
    userFiles=`ls $userPath`
    for userFile in $userFiles
    do  
        if [ "${userFile}" -ge "500" ];then
            userState=`awk -F= '{ if($1=="STATE") print $2}' ${userPath}/${userFile}`
            if [ ${userState} == "active" ];then
                user=`awk -F= '{ if($1=="NAME") print $2}' ${userPath}/${userFile}`
                break
            fi  
        fi  
    done

    if [ "$user" == "" ];then
        user=root
    fi  
}

prog="ProxKeyUISvr.jar"
BIN_PATH=/usr/lib/WatchData/ProxKey/tools/
RUNJAR=`ps -ef | grep ${prog} | grep -v grep | awk '{print $2}'`
if [ "x${RUNJAR}" != "x" ]; then
    exit 0
fi

cd "${BIN_PATH}"
LanguageInfo=$(echo $LANG |tr [A-Z] [a-z]|grep "zh")
export LC_ALL="en_US.UTF-8"

whichjava=$(which java)
if [ "$whichjava" != "" ]; then
    java -Djava.library.path="${BIN_PATH}" -jar ${prog} &
    exit 0
else
    jrepath=$(find / -type d -name "jre*" -exec bash -c 'find {} -type f -name java' \; 2>/dev/null)
    if [ "$jrepath" != "" ]; then
        $jrepath -Djava.library.path="${BIN_PATH}" -jar ${prog} &
        exit 0
    fi
    jdkpath=$(find / -type d -name "jdk*" -exec bash -c 'find {} -type f -name java' \; 2>/dev/null)
    if [ "$jdkpath" != "" ]; then
        $jdkpath -Djava.library.path="${BIN_PATH}" -jar ${prog} &
        exit 0
    fi
fi

showUser=$(getUser)

if [ "$runUser" != "$showUser" ]; then
    whichjava=$(sudo -i -u $showUser which java)
    if [ "$whichjava" != "" ]; then
        sudo -i -u $showUser java -Djava.library.path="${BIN_PATH}" -jar ${prog} &
        exit 0
    fi
fi

java -Djava.library.path="${BIN_PATH}" -jar ${prog} >>/tmp/uilog.txt 2>&1 &

